CREATE TABLE "VENDEUR" 
(
  "CODEVENDEUR"	CHAR(1) NOT NULL,
  "NOMVENDEUR"	CHAR(25),
  "PRENOMVENDEUR"	CHAR(25),
 PRIMARY KEY ("CODEVENDEUR")
);

CREATE TABLE "PRODUIT" 
(
  "REFPDT"		CHAR(5) NOT NULL,
  "DESPDT"		CHAR(50),
  "PUHTPDT"		DECIMAL(5, 2),
 PRIMARY KEY ("REFPDT")
);

CREATE TABLE "CLIENT" 
(
  "NUMCLT"			INTEGER NOT NULL,
  "CODEVENDEUR"		CHAR(1) NOT NULL,
  "NOMCLT"			CHAR(25),
  "ADR1CLT"			CHAR(30),
  "ADR2CLT"			CHAR(30),
  "CPVILLECLT"		CHAR(30),
  "TELCLT"			CHAR(10),
  "EMAILCLT"		CHAR(30),
  "REPLIQUE"		NUMERIC(1, 0),
 PRIMARY KEY ("NUMCLT")
);
ALTER TABLE "CLIENT" 
ADD FOREIGN KEY ("CODEVENDEUR") 
REFERENCES VENDEUR ("CODEVENDEUR");

 
CREATE TABLE "COMMANDE" 
(
  "CODEVENDEUR"		CHAR(1) NOT NULL,
  "NUMCDE"			INTEGER NOT NULL,
  "NUMCLT"			INTEGER NOT NULL,
  "DATECDE"		DATE,
 PRIMARY KEY ("CODEVENDEUR", "NUMCDE")
);
ALTER TABLE "COMMANDE" 
ADD FOREIGN KEY ("NUMCLT") 
REFERENCES CLIENT ("NUMCLT");
ALTER TABLE "COMMANDE" 
ADD FOREIGN KEY ("CODEVENDEUR") 
REFERENCES VENDEUR ("CODEVENDEUR");

CREATE TABLE "CONTENIR" 
(
  "CODEVENDEUR"		CHAR(1) NOT NULL,
  "NUMCDE"			INTEGER NOT NULL,
  "REFPDT"			CHAR(5) NOT NULL,
  "QTE"			INTEGER,
  "PU"				DECIMAL(5, 2),
 PRIMARY KEY ("CODEVENDEUR", "NUMCDE", "REFPDT")
);
ALTER TABLE "CONTENIR" 	
ADD FOREIGN KEY ("CODEVENDEUR", "NUMCDE") 
REFERENCES COMMANDE ("CODEVENDEUR", "NUMCDE");
ALTER TABLE "CONTENIR" 
ADD FOREIGN KEY ("REFPDT") 
REFERENCES PRODUIT ("REFPDT");
